/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.periph.keyboard;

public class ScanCode {
    public static final byte SCANCODE_KEY_RELEASED = -16;
    private int byteIdx;
    private int nbBytes;
    private byte[] bytes = new byte[4];

    public final synchronized void reset(boolean bl, int n) {
        this.byteIdx = 0;
        if ((n & 0xFFFFFF00) == 0) {
            int n2 = 0;
            if (bl) {
                n2 = 1;
                this.bytes[0] = -16;
            }
            this.bytes[n2] = (byte)n;
            this.nbBytes = n2 + 1;
        } else {
            int n3;
            int n4 = n3 = bl ? 1 : 0;
            if ((n & 0xFF000000) != 0) {
                throw new UnsupportedOperationException("4 bytes wide scancodes (or more) are not supported!");
            }
            n3 = (n & 0xFF0000) != 0 ? (n3 += 3) : (n3 += 2);
            this.nbBytes = n3;
            while (--n3 >= 0) {
                this.bytes[n3] = (byte)n;
                n >>>= 8;
                if (!bl || n3 != 2) continue;
                this.bytes[1] = -16;
                this.bytes[0] = (byte)n;
                break;
            }
        }
    }

    public final synchronized int getNextByte() {
        return 0xFF & this.bytes[this.byteIdx++];
    }

    public final synchronized void rewind() {
        this.byteIdx = 0;
    }

    public final synchronized boolean hasNextByte() {
        return this.byteIdx < this.nbBytes;
    }

    public final synchronized byte[] getBytes() {
        byte[] byArray = new byte[this.nbBytes];
        System.arraycopy(this.bytes, 0, byArray, 0, this.nbBytes);
        return byArray;
    }
}

